/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools;

import com.google.common.collect.Lists;
import dev.ftb.ftbsbc.portal.PortalRegistry;
import dev.ftb.ftbsbc.tools.ToolsRegistry;
import dev.ftb.ftbsbc.tools.ToolsTags;
import dev.ftb.ftbsbc.tools.content.autohammer.AutoHammerBlock;
import dev.ftb.ftbsbc.tools.loot.CrookModifier;
import dev.ftb.ftbsbc.tools.loot.HammerModifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ftbsbc", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolsData {
    public static final String MODID = "ftbsbc";

    @SubscribeEvent
    public static void dataGenEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            SMBlockModels blockModels = new SMBlockModels(gen, MODID, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockModels);
            gen.m_123914_((DataProvider)new SMLang(gen, MODID, "en_us"));
            gen.m_123914_((DataProvider)new SMItemModels(gen, MODID, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new SMBlockStateModels(gen, MODID, event.getExistingFileHelper(), blockModels));
        }
        if (event.includeServer()) {
            SMBlockTags blockTags = new SMBlockTags(gen, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockTags);
            gen.m_123914_((DataProvider)new SMItemTags(gen, blockTags, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new SMRecipes(gen));
            gen.m_123914_((DataProvider)new SMLootTableProvider(gen));
            gen.m_123914_((DataProvider)new SMLootModifiers(gen));
        }
    }

    private static class SMBlockModels
    extends BlockModelProvider {
        public SMBlockModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
        }
    }

    private static class SMLang
    extends LanguageProvider {
        public SMLang(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        protected void addTranslations() {
            this.add("itemGroup.ftbsbc", "StoneBlock Tools");
            this.addItem((Supplier)ToolsRegistry.STONE_HAMMER, "Stone Hammer");
            this.addItem((Supplier)ToolsRegistry.IRON_HAMMER, "Iron Hammer");
            this.addItem((Supplier)ToolsRegistry.GOLD_HAMMER, "Gold Hammer");
            this.addItem((Supplier)ToolsRegistry.DIAMOND_HAMMER, "Diamond Hammer");
            this.addItem((Supplier)ToolsRegistry.NETHERITE_HAMMER, "Netherite Hammer");
            this.addItem((Supplier)ToolsRegistry.CROOK, "Stone Crook");
            this.addItem((Supplier)ToolsRegistry.STONE_ROD, "Stone Rod");
            this.addBlock((Supplier)ToolsRegistry.IRON_AUTO_HAMMER, "Iron Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.GOLD_AUTO_HAMMER, "Gold Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.DIAMOND_AUTO_HAMMER, "Diamond Auto-hammer");
            this.addBlock((Supplier)ToolsRegistry.NETHERITE_AUTO_HAMMER, "Netherite Auto-hammer");
            this.addItem((Supplier)ToolsRegistry.FIRE_PLOW, "Fire Plow");
            this.addBlock((Supplier)PortalRegistry.SB_PORTAL_BLOCK, "StoneBlock Portal");
            this.addBlock((Supplier)ToolsRegistry.BITS_SPAWNER, "Bits Spawner");
            this.add("screens.ftbsbc.select_start_group", "Select a group");
            this.add("screens.ftbsbc.select_start", "Select a start");
            this.add("screens.ftbsbc.selected_start", "Selected start");
            this.add("screens.ftbsbc.by", "By: %s");
            this.add("screens.ftbsbc.back", "Back");
            this.add("screens.ftbsbc.create", "Create");
            this.add("screens.ftbsbc.select", "Select");
            this.add("screens.ftbsbc.close", "Close");
            this.add("ftbsbc.tooltip.fireplow", "Hold right click whilst looking at Stone to create lava");
            this.add("ftbsbc.tooltip.hammers", "Crushes materials down to their core components");
            this.add("ftbsbc.tooltip.auto-hammers", "Automatically crushes materials down using the hammer based on the tier of hammer");
            this.add("ftbsbc.jade.waiting", "Waiting for input: %s ticks");
            this.add("ftbsbc.jade.processing", "Processing: %s/%s");
            this.add("ftbsbc.jade.input", "Input");
            this.add("ftbsbc.jade.buffer", "Buffer");
        }
    }

    private static class SMItemModels
    extends ItemModelProvider {
        public SMItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
            this.registerBlockModel((Block)ToolsRegistry.IRON_AUTO_HAMMER.get());
            this.registerBlockModel((Block)ToolsRegistry.GOLD_AUTO_HAMMER.get());
            this.registerBlockModel((Block)ToolsRegistry.DIAMOND_AUTO_HAMMER.get());
            this.registerBlockModel((Block)ToolsRegistry.NETHERITE_AUTO_HAMMER.get());
            this.simpleItem((Supplier<Item>)ToolsRegistry.STONE_HAMMER);
            this.simpleItem((Supplier<Item>)ToolsRegistry.IRON_HAMMER);
            this.simpleItem((Supplier<Item>)ToolsRegistry.GOLD_HAMMER);
            this.simpleItem((Supplier<Item>)ToolsRegistry.DIAMOND_HAMMER);
            this.simpleItem((Supplier<Item>)ToolsRegistry.NETHERITE_HAMMER);
            this.simpleItem((Supplier<Item>)ToolsRegistry.CROOK);
            this.simpleItem((Supplier<Item>)ToolsRegistry.STONE_ROD);
            this.simpleItem((Supplier<Item>)ToolsRegistry.FIRE_PLOW);
        }

        private void simpleItem(Supplier<Item> item) {
            String path = item.get().getRegistryName().m_135815_();
            this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
        }

        private void registerBlockModel(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }
    }

    private static class SMBlockStateModels
    extends BlockStateProvider {
        private final SMBlockModels blockModels;

        public SMBlockStateModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper, SMBlockModels bm) {
            super(generator, modid, existingFileHelper);
            this.blockModels = bm;
        }

        public BlockModelProvider models() {
            return this.blockModels;
        }

        protected void registerStatesAndModels() {
            Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
            int[] dirsRot = new int[]{0, 180, 270, 90};
            ArrayList<Pair<String, RegistryObject<Block>>> hammerTypes = new ArrayList<Pair<String, RegistryObject<Block>>>(){
                {
                    this.add(Pair.of((Object)"iron", ToolsRegistry.IRON_AUTO_HAMMER));
                    this.add(Pair.of((Object)"gold", ToolsRegistry.GOLD_AUTO_HAMMER));
                    this.add(Pair.of((Object)"diamond", ToolsRegistry.DIAMOND_AUTO_HAMMER));
                    this.add(Pair.of((Object)"netherite", ToolsRegistry.NETHERITE_AUTO_HAMMER));
                }
            };
            for (Pair pair : hammerTypes) {
                MultiPartBlockStateBuilder b = this.getMultipartBuilder((Block)((RegistryObject)pair.getRight()).get());
                String path = ((Block)((RegistryObject)pair.getRight()).get()).getRegistryName().m_135815_();
                for (int d = 0; d < 4; ++d) {
                    ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path))).rotationY(dirsRot[d]).addModel()).condition((Property)AutoHammerBlock.ACTIVE, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dirs[d]});
                    ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path + "_active"))).rotationY(dirsRot[d]).addModel()).condition((Property)AutoHammerBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dirs[d]});
                }
            }
        }
    }

    private static class SMBlockTags
    extends BlockTagsProvider {
        public SMBlockTags(DataGenerator generatorIn, ExistingFileHelper helper) {
            super(generatorIn, ToolsData.MODID, helper);
        }

        protected void m_6577_() {
            Object[] blocks = (Block[])Set.of((Block)ToolsRegistry.IRON_AUTO_HAMMER.get(), (Block)ToolsRegistry.GOLD_AUTO_HAMMER.get(), (Block)ToolsRegistry.DIAMOND_AUTO_HAMMER.get(), (Block)ToolsRegistry.NETHERITE_AUTO_HAMMER.get()).toArray(Block[]::new);
            this.m_206424_(BlockTags.f_144282_).m_126584_(blocks).m_126582_((Object)((Block)ToolsRegistry.BITS_SPAWNER.get()));
            this.m_206424_(Tags.Blocks.NEEDS_WOOD_TOOL).m_126584_(blocks);
            this.m_206424_(ToolsTags.Blocks.AUTO_HAMMERS).m_126584_(blocks);
        }
    }

    private static class SMItemTags
    extends ItemTagsProvider {
        public SMItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, ExistingFileHelper helper) {
            super(dataGenerator, blockTagProvider, ToolsData.MODID, helper);
        }

        protected void m_6577_() {
            this.m_206424_(ToolsTags.Items.HAMMERS).m_126584_((Object[])new Item[]{(Item)ToolsRegistry.STONE_HAMMER.get(), (Item)ToolsRegistry.IRON_HAMMER.get(), (Item)ToolsRegistry.GOLD_HAMMER.get(), (Item)ToolsRegistry.DIAMOND_HAMMER.get(), (Item)ToolsRegistry.NETHERITE_HAMMER.get()});
            this.m_206424_(ToolsTags.Items.CROOKS).m_126582_((Object)((Item)ToolsRegistry.CROOK.get()));
        }
    }

    private static class SMRecipes
    extends RecipeProvider {
        public SMRecipes(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            this.hammer((ItemLike)ToolsRegistry.STONE_HAMMER.get(), (ItemLike)Items.f_42594_, consumer);
            this.hammer((ItemLike)ToolsRegistry.IRON_HAMMER.get(), (ItemLike)Items.f_42416_, consumer);
            this.hammer((ItemLike)ToolsRegistry.GOLD_HAMMER.get(), (ItemLike)Items.f_42417_, consumer);
            this.hammer((ItemLike)ToolsRegistry.DIAMOND_HAMMER.get(), (ItemLike)Items.f_42415_, consumer);
            this.hammer((ItemLike)ToolsRegistry.NETHERITE_HAMMER.get(), (ItemLike)Items.f_42418_, consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ToolsRegistry.FIRE_PLOW.get())).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)Items.f_42398_)).m_126130_("S  ").m_126130_(" S ").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_176498_(consumer);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ToolsRegistry.STONE_ROD.get()), (int)2).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)Items.f_42594_)).m_126130_("S").m_126130_("S").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42594_).m_176498_(consumer);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ToolsRegistry.CROOK.get()), (int)1).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)((ItemLike)ToolsRegistry.STONE_ROD.get()))).m_126130_("RR ").m_126130_(" R ").m_126130_(" R ").m_126127_(Character.valueOf('R'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ToolsRegistry.IRON_AUTO_HAMMER.get())).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)((ItemLike)ToolsRegistry.IRON_HAMMER.get()))).m_126130_("IGI").m_126130_("XHX").m_126130_("RGR").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('X'), Tags.Items.GLASS).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('H'), (ItemLike)ToolsRegistry.IRON_HAMMER.get()).m_176498_(consumer);
            this.autoHammer((ItemLike)ToolsRegistry.GOLD_AUTO_HAMMER.get(), (Item)ToolsRegistry.IRON_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.GOLD_HAMMER.get(), consumer);
            this.autoHammer((ItemLike)ToolsRegistry.DIAMOND_AUTO_HAMMER.get(), (Item)ToolsRegistry.GOLD_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.DIAMOND_HAMMER.get(), consumer);
            this.autoHammer((ItemLike)ToolsRegistry.NETHERITE_AUTO_HAMMER.get(), (Item)ToolsRegistry.DIAMOND_AUTO_HAMMER_BLOCK_ITEM.get(), (Item)ToolsRegistry.NETHERITE_HAMMER.get(), consumer);
        }

        private void autoHammer(ItemLike output, Item center, Item top, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)center)).m_126130_("ITI").m_126130_("XCX").m_126130_("RGR").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('X'), Tags.Items.GLASS).m_126127_(Character.valueOf('T'), (ItemLike)top).m_126127_(Character.valueOf('C'), (ItemLike)center).m_176498_(consumer);
        }

        private void hammer(ItemLike output, TagKey<Item> head, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_206406_(head)).m_126130_("hrh").m_126130_(" r ").m_126130_(" r ").m_206416_(Character.valueOf('h'), head).m_126127_(Character.valueOf('r'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
        }

        private void hammer(ItemLike output, ItemLike head, Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)output).m_142284_("has_item", (CriterionTriggerInstance)SMRecipes.m_125977_((ItemLike)head)).m_126130_("hrh").m_126130_(" r ").m_126130_(" r ").m_126127_(Character.valueOf('h'), head).m_126127_(Character.valueOf('r'), (ItemLike)ToolsRegistry.STONE_ROD.get()).m_176498_(consumer);
        }
    }

    private static class SMLootTableProvider
    extends LootTableProvider {
        public SMLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<com.mojang.datafixers.util.Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return Lists.newArrayList((Object[])new com.mojang.datafixers.util.Pair[]{com.mojang.datafixers.util.Pair.of(SMBlockLootProvider::new, (Object)LootContextParamSets.f_81421_)});
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext tracker) {
            map.forEach((k, v) -> LootTables.m_79202_((ValidationContext)tracker, (ResourceLocation)k, (LootTable)v));
        }
    }

    private static class SMLootModifiers
    extends GlobalLootModifierProvider {
        public SMLootModifiers(DataGenerator gen) {
            super(gen, ToolsData.MODID);
        }

        protected void start() {
            this.add("crook_loot_modifier", (GlobalLootModifierSerializer)ToolsRegistry.CROOK_LOOT_MODIFIER.get(), (IGlobalLootModifier)new CrookModifier(new LootItemCondition[]{MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ToolsTags.Items.CROOKS)).m_6409_()}));
            this.add("hammer_loot_modifier", (GlobalLootModifierSerializer)ToolsRegistry.HAMMER_LOOT_MODIFIER.get(), (IGlobalLootModifier)new HammerModifier(new LootItemCondition[]{MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ToolsTags.Items.HAMMERS)).m_6409_()}));
        }
    }

    public static class SMBlockLootProvider
    extends BlockLoot {
        Set<Block> blocks = new HashSet<Block>();

        protected void addTables() {
            this.m_124288_((Block)ToolsRegistry.IRON_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.GOLD_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.DIAMOND_AUTO_HAMMER.get());
            this.m_124288_((Block)ToolsRegistry.NETHERITE_AUTO_HAMMER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks;
        }

        protected void m_124165_(Block blockIn, LootTable.Builder table) {
            this.blocks.add(blockIn);
            super.m_124165_(blockIn, table);
        }
    }
}

